/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresInformacionEstablecimiento;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class InformacionEstablecimiento
extends PaginaAsistente
implements VistaModelo<Recap>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private Recap modeloDatos;
    private ModeloValoresInformacionEstablecimiento modeloValores;
    private Text txtNumIdentificacion;
    private Text txtNumRecap;
    private ComboViewer cvIdentificacionEstab;
    private ComboViewer cvtipoComprobante;
    private ComboViewer cvTarjetaCredito;
    private Label lblesParteRelacionada;
    private Composite compositeParteRel;
    private final Periodo periodo;
    private Button btnSiParRel;
    private Button btnNoParRel;
    private Text txtRazonSocial;
    private Composite compositeRazonSocial;
    private Combo cmbTipoProveedor;
    private ComboViewer cvTipoProveedor;

    public InformacionEstablecimiento(boolean editando, Periodo periodo) {
        super("InformacionEstablecimiento", "Anexo TransaccionalEstablecimiento-Comprobante Recap", "Especifique la informaci\u00f3n correspondiente");
        this.setTitle("Establecimiento-Comprobante Recap");
        this.editando = editando;
        this.periodo = periodo;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresInformacionEstablecimiento();
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(Recap modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        String codTipoIdentificacion = this.modeloDatos.getEstablecimiento().getTipoIdentificacion();
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codTipoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvIdentificacionEstab, (Object)tipoIdentificacion);
        this.cargarRazonSocial(codTipoIdentificacion);
        String codigoTipoComprobante = this.modeloDatos.getRecap().getTipoComprobante();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codigoTipoComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvtipoComprobante, (Object)tipoComprobante);
        String codTipoTarjeta = this.modeloDatos.getRecap().getTipoTarjetaCredito();
        ElementoNombreValor tipoTarjeta = this.modeloValores.obtenerTipoTarjeta(codTipoTarjeta);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTarjetaCredito, (Object)tipoTarjeta);
        ContextoValidacion ctxVal = new ContextoValidacion().agregar(InfoPantallas.RECAP_INFORMACION_ESTABLECIMIENTO.toString(), (Object)InfoPantallas.RECAP_INFORMACION_ESTABLECIMIENTO);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, ctxVal, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getRecap().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getEstablecimiento().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void cargarRazonSocial(String codTipoIdentificacion) {
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016() && "P".equals(codTipoIdentificacion)) {
            String codigoTipoProv = this.modeloDatos.getEstablecimiento().getTipoProveedor();
            ElementoNombreValor tipoProv = this.modeloValores.obtenerTipoProveedor(codigoTipoProv);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoProveedor, (Object)tipoProv);
            this.compositeRazonSocial.setVisible(true);
        } else {
            this.compositeRazonSocial.setVisible(false);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblInformacinEstablecimiento = new Label(container, 0);
        GridData gd_lblInformacinEstablecimiento = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinEstablecimiento.verticalIndent = 3;
        lblInformacinEstablecimiento.setLayoutData((Object)gd_lblInformacinEstablecimiento);
        lblInformacinEstablecimiento.setText("Informaci\u00f3n Establecimiento");
        lblInformacinEstablecimiento.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinEstablecimiento.getFont()));
        new Label(container, 0);
        Label lblTipoIdentificacinEstablecimiento = new Label(container, 0);
        GridData gd_lblTipoIdentificacinEstablecimiento = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdentificacinEstablecimiento.widthHint = 200;
        lblTipoIdentificacinEstablecimiento.setLayoutData((Object)gd_lblTipoIdentificacinEstablecimiento);
        lblTipoIdentificacinEstablecimiento.setText("Tipo Id. Establecimiento");
        this.cvIdentificacionEstab = new ComboViewer(container, 8);
        this.cvIdentificacionEstab.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoId = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoId != null) {
                    InformacionEstablecimiento.this.modeloDatos.getEstablecimiento().setTipoIdentificacion((String)tipoId.getValor());
                    InformacionEstablecimiento.this.modeloDatos.getEstablecimiento().setDescripcionTipoIdentificacion(tipoId.getNombre());
                    InformacionEstablecimiento.this.renderizarRazonSocialEnBaseAlPeriodo((ElementoNombreValor<String>)tipoId);
                    boolean esPasaporte = "P".equals(tipoId.getValor());
                    InformacionEstablecimiento.this.renderizarRazonSocialParaAnexosDesdeMayo2016(esPasaporte);
                }
            }
        });
        Combo combo = this.cvIdentificacionEstab.getCombo();
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 330;
        combo.setLayoutData((Object)gd_combo);
        Label lblNIdentificacin = new Label(container, 0);
        lblNIdentificacin.setText("N\u00b0 Identificaci\u00f3n");
        this.txtNumIdentificacion = new Text(container, 2048);
        this.txtNumIdentificacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                InformacionEstablecimiento.this.txtNumIdentificacion.selectAll();
            }
        });
        this.txtNumIdentificacion.setTextLimit(13);
        GridData gd_txtNumIdentificacion = new GridData(16384, 128, true, false, 1, 1);
        gd_txtNumIdentificacion.widthHint = 115;
        this.txtNumIdentificacion.setLayoutData((Object)gd_txtNumIdentificacion);
        this.lblesParteRelacionada = new Label(container, 0);
        this.lblesParteRelacionada.setText("\u00bfEs parte Relacionada?");
        this.compositeParteRel = new Composite(container, 0);
        this.compositeParteRel.setLayout((Layout)new GridLayout(2, false));
        this.btnSiParRel = new Button(this.compositeParteRel, 16);
        this.btnSiParRel.setText("SI");
        this.btnNoParRel = new Button(this.compositeParteRel, 16);
        this.btnNoParRel.setText("NO");
        this.compositeRazonSocial = new Composite(container, 0);
        GridData gd_compositeRazonSocial = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_compositeRazonSocial.heightHint = 58;
        gd_compositeRazonSocial.widthHint = 447;
        this.compositeRazonSocial.setLayoutData((Object)gd_compositeRazonSocial);
        Label lblTipoEstablecimiento = new Label(this.compositeRazonSocial, 0);
        lblTipoEstablecimiento.setBounds(0, 9, 139, 15);
        lblTipoEstablecimiento.setText("Tipo Establecimiento");
        this.cmbTipoProveedor = new Combo(this.compositeRazonSocial, 0);
        this.cvTipoProveedor = new ComboViewer(this.compositeRazonSocial, 8);
        this.cvTipoProveedor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoProveedor = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoProveedor != null) {
                    InformacionEstablecimiento.this.modeloDatos.getEstablecimiento().setTipoProveedor((String)tipoProveedor.getValor());
                    InformacionEstablecimiento.this.modeloDatos.getEstablecimiento().setDescripcionTipoProveedor(tipoProveedor.getNombre());
                }
            }
        });
        this.cmbTipoProveedor = this.cvTipoProveedor.getCombo();
        this.cmbTipoProveedor.setBounds(205, 0, 156, 23);
        Label lblRazonSocial = new Label(this.compositeRazonSocial, 0);
        lblRazonSocial.setBounds(0, 30, 66, 15);
        lblRazonSocial.setText("Raz\u00f3n Social");
        this.txtRazonSocial = new Text(this.compositeRazonSocial, 2048);
        this.txtRazonSocial.setBounds(205, 27, 232, 25);
        this.txtRazonSocial.setTextLimit(100);
        this.txtRazonSocial.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                InformacionEstablecimiento.this.txtRazonSocial.selectAll();
            }
        });
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        Label lblInformacinComprobante = new Label(container, 0);
        lblInformacinComprobante.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinComprobante.getFont()));
        GridData gd_lblInformacinComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinComprobante.verticalIndent = 15;
        lblInformacinComprobante.setLayoutData((Object)gd_lblInformacinComprobante);
        lblInformacinComprobante.setText("Informaci\u00f3n Comprobante");
        new Label(container, 0);
        Label lblTipoComprobante = new Label(container, 0);
        lblTipoComprobante.setText("Tipo Comprobante");
        this.cvtipoComprobante = new ComboViewer(container, 8);
        this.cvtipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoComprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoComprobante != null) {
                    InformacionEstablecimiento.this.modeloDatos.getRecap().setTipoComprobante((String)tipoComprobante.getValor());
                    InformacionEstablecimiento.this.modeloDatos.getRecap().setDescripcionTipoComprobante(tipoComprobante.getNombre());
                }
            }
        });
        Combo combo_1 = this.cvtipoComprobante.getCombo();
        GridData gd_combo_1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 175;
        combo_1.setLayoutData((Object)gd_combo_1);
        Label lblNumeroRecap = new Label(container, 0);
        lblNumeroRecap.setText("Numero RECAP");
        this.txtNumRecap = new Text(container, 2048);
        this.txtNumRecap.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                InformacionEstablecimiento.this.txtNumRecap.selectAll();
            }
        });
        this.txtNumRecap.setTextLimit(15);
        GridData gd_txtNumRecap = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumRecap.widthHint = 115;
        this.txtNumRecap.setLayoutData((Object)gd_txtNumRecap);
        Label lblFechaDePago = new Label(container, 0);
        lblFechaDePago.setText("Fecha de Pago");
        final CDateTime fechaPago = new CDateTime(container, 32771);
        fechaPago.setNullText("seleccione la fecha");
        fechaPago.setPattern("dd/MM/yyyy");
        fechaPago.setSelection(this.modeloDatos.getRecap().getFechaPago());
        fechaPago.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InformacionEstablecimiento.this.modeloDatos.getRecap().setFechaPago(fechaPago.getSelection());
            }
        });
        GridData gd_fechaPago = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fechaPago.widthHint = 125;
        fechaPago.setLayoutData((Object)gd_fechaPago);
        Label lblTarjetaDeCrdito = new Label(container, 0);
        lblTarjetaDeCrdito.setText("Tarjeta de Cr\u00e9dito");
        this.cvTarjetaCredito = new ComboViewer(container, 8);
        this.cvTarjetaCredito.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoTarjeta = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoTarjeta != null) {
                    InformacionEstablecimiento.this.modeloDatos.getRecap().setTipoTarjetaCredito((String)tipoTarjeta.getValor());
                    InformacionEstablecimiento.this.modeloDatos.getRecap().setDescripcionTarjetaCredito(tipoTarjeta.getNombre());
                }
            }
        });
        Combo combo_2 = this.cvTarjetaCredito.getCombo();
        GridData gd_combo_2 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_2.widthHint = 175;
        combo_2.setLayoutData((Object)gd_combo_2);
        Label lblFechaDeEmisin = new Label(container, 0);
        lblFechaDeEmisin.setText("Fecha de Emisi\u00f3n");
        final CDateTime fechaEmision = new CDateTime(container, 32771);
        fechaEmision.setNullText("seleccione la fecha");
        fechaEmision.setPattern("dd/MM/yyyy");
        fechaEmision.setSelection(this.modeloDatos.getRecap().getFechaEmision());
        fechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InformacionEstablecimiento.this.modeloDatos.getRecap().setFechaEmision(fechaEmision.getSelection());
            }
        });
        GridData gd_fechaEmision = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fechaEmision.widthHint = 125;
        fechaEmision.setLayoutData((Object)gd_fechaEmision);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    private void renderizarRazonSocialEnBaseAlPeriodo(ElementoNombreValor<String> tipoID) {
        boolean esPasaporte = "P".equals(tipoID.getValor());
        this.renderizarRazonSocialParaAnexosDesdeMayo2016(esPasaporte);
    }

    private void renderizarRazonSocialParaAnexosDesdeMayo2016(boolean esPasaporte) {
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.compositeRazonSocial.setVisible(esPasaporte);
            if (!esPasaporte) {
                this.txtRazonSocial.setText("");
                this.modeloDatos.getEstablecimiento().setTipoProveedor(null);
                this.modeloDatos.getEstablecimiento().setDescripcionTipoProveedor("");
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvIdentificacionEstab.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvIdentificacionEstab.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposIdentificacionEstablecimientoModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacionEstablecimiento").observe((Object)this.modeloValores);
        this.cvIdentificacionEstab.setInput((Object)tiposIdentificacionEstablecimientoModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvtipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvtipoComprobante.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList tiposComprobantesModeloValoresObserveList = PojoProperties.list((String)"tiposComprobantes").observe((Object)this.modeloValores);
        this.cvtipoComprobante.setInput((Object)tiposComprobantesModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTarjetaCredito.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvTarjetaCredito.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList tiposTarjetasModeloValoresObserveList = PojoProperties.list((String)"tiposTarjetas").observe((Object)this.modeloValores);
        this.cvTarjetaCredito.setInput((Object)tiposTarjetasModeloValoresObserveList);
        ISWTObservableValue observeTextTxtNumIdentificacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumIdentificacion);
        IObservableValue identificacionModeloDatosgetEstablecimientoObserveValue = BeanProperties.value((String)"identificacion").observe((Object)this.modeloDatos.getEstablecimiento());
        bindingContext.bindValue((IObservableValue)observeTextTxtNumIdentificacionObserveWidget, identificacionModeloDatosgetEstablecimientoObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumRecapObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumRecap);
        IObservableValue numeroRecapModeloDatosgetRecapObserveValue = BeanProperties.value((String)"numeroRecap").observe((Object)this.modeloDatos.getRecap());
        bindingContext.bindValue((IObservableValue)observeTextTxtNumRecapObserveWidget, numeroRecapModeloDatosgetRecapObserveValue, null, null);
        ISWTObservableValue btnSiParRelObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiParRel);
        IObservableValue modeloDatosEstablecimientoparteRelacionadaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"establecimiento.parteRelacionada");
        bindingContext.bindValue((IObservableValue)btnSiParRelObserveSelectionObserveWidget, modeloDatosEstablecimientoparteRelacionadaObserveValue, null, null);
        ISWTObservableValue btnNoParRelObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoParRel);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoParRelObserveSelectionObserveWidget, modeloDatosEstablecimientoparteRelacionadaObserveValue, strategy, strategy_1);
        ISWTObservableValue lblesParteRelacionadaObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblesParteRelacionada);
        IObservableValue periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDeAnexoDesdeMarzo2015");
        bindingContext.bindValue((IObservableValue)lblesParteRelacionadaObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue compositeParteRelObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.compositeParteRel);
        bindingContext.bindValue((IObservableValue)compositeParteRelObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue compositeRazonSocialObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.compositeRazonSocial);
        IObservableValue periodoAnexoEnPeriodoDesdeMayo2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMayo2016");
        bindingContext.bindValue((IObservableValue)compositeRazonSocialObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMayo2016ObserveValue, null, null);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosgetEstablecimientoRazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos.getEstablecimiento(), (String)"razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosgetEstablecimientoRazonSocialObserveValue, null, null);
        ObservableListContentProvider listContentProvider_3 = new ObservableListContentProvider();
        IObservableMap observeMap_3 = PojoObservables.observeMap((IObservableSet)listContentProvider_3.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoProveedor.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_3));
        this.cvTipoProveedor.setContentProvider((IContentProvider)listContentProvider_3);
        IObservableList modeloValoresTiposProveedorObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposProveedor");
        this.cvTipoProveedor.setInput((Object)modeloValoresTiposProveedorObserveList);
        return bindingContext;
    }
}

